﻿using System;
using NCMS.Utils;
using UnityEngine;
using UnityEngine.Events;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text.RegularExpressions;
using System.Reflection;
using ReflectionUtility;

namespace Diplomacy_Army
{
    class WorldLowPowerWindow
    {
        public static string name = "WorldLowControlWindow";
        public static PowerButton powerButton;

        private static ScrollWindow window;
        private static GameObject content;
        private static GodPower power;
        private static int index = 0;

        // Initializing Tiles Window
        internal static PowerButtonSelector pbsInstance;
        public static void init()
        {
            // Creating new window
            window = Windows.CreateNewWindow(name, "Select Tile");

            // Activating Scroll View object
            var scrollView = GameObject.Find($"/Canvas Container Main/Canvas - Windows/windows/{window.name}/Background/Scroll View");
            scrollView.gameObject.SetActive(true);


            // Fixing size to fit
            var viewport = GameObject.Find($"/Canvas Container Main/Canvas - Windows/windows/{window.name}/Background/Scroll View/Viewport");
            var viewportRect = viewport.GetComponent<RectTransform>();
            viewportRect.sizeDelta = new Vector2(0, 17);

            // Getting Content object
            content = GameObject.Find($"/Canvas Container Main/Canvas - Windows/windows/{window.name}/Background/Scroll View/Viewport/Content");

            // Getting power button selector using reflections with ReflectionUtility
            pbsInstance = Reflection.GetField(typeof(PowerButtonSelector), null, "instance") as PowerButtonSelector;

            initWorldLowControl();
        }
        private static void initWorldLowControl()
        {
            createTileButton(index++, content.transform, "封锁边境", "historyLog", "禁止非己方或友军单位从己方领土上通过");
            createTileButton(index++, content.transform, "更多外交", "historyLog", "允许AI自动签条约");
            createTileButton(index++, content.transform, "显示条约", "historyLog", "显示已签订的条约");
            createTileButton(index++, content.transform, "显示交战", "historyLog", "显示正在交战的国家");
            createTileButton(index++, content.transform, "显示外交消息", "historyLog", "显示国家执行的外交操作");

        }
        private static void createTileButton(int index, Transform pParent, string powerID, string pSprite, string pDescription, UnityAction pCall = null)
        {
            GodPower godPower = new GodPower();
            godPower.id = powerID;
            godPower.name = powerID;
            godPower.unselectWhenWindow = true;
            godPower.toggle_action = (PowerToggleAction)Delegate.Combine(godPower.toggle_action, new PowerToggleAction(MoreGodPower.toggleOption));
            AssetManager.powers.add(godPower);
            NewFunction.CreateNewButtonOnWindow(NewFunction.getPositionByIndex(index), pParent, pSprite, godPower, pDescription, pCall, PowerButtonType.Special);
        }
    }
}
